// PortOpen.cpp: CPortOpen NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "GetStatus.h"
#include "PortOpen.h"
#include "MyGlobal.h"

#include <WINIOCTL.H>
//#include "NTDDPAR.H"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CPortOpen::CPortOpen()
{

}

CPortOpen::~CPortOpen()
{

}

BOOL CPortOpen::SelectPort()
{
	COMMTIMEOUTS Timeouts;

	DCB			Dcb;
	CString		strBuffer;
	int			iError;

	switch(Communication.nPort)
	{
		default: strBuffer = "\\\\.\\COM1"; break;
		case 0:  strBuffer = "\\\\.\\COM1"; break;
		case 1:  strBuffer = "\\\\.\\COM2"; break;
		case 2:  strBuffer = "\\\\.\\COM3"; break;
		case 3:  strBuffer = "\\\\.\\COM4"; break;
		case 4:  strBuffer = "\\\\.\\COM5"; break;
		case 5:  strBuffer = "\\\\.\\COM6"; break;
		case 6:  strBuffer = "\\\\.\\COM7"; break;
		case 7:  strBuffer = "\\\\.\\COM8"; break;
		case 8:  strBuffer = "\\\\.\\COM9"; break;
		case 9:  strBuffer = "\\\\.\\COM10"; break;
		case 10:  strBuffer = "\\\\.\\COM11"; break;
		case 11:  strBuffer = "\\\\.\\COM12"; break;
		case 12:  strBuffer = "\\\\.\\COM13"; break;
		case 13:  strBuffer = "\\\\.\\COM14"; break;
		case 14:  strBuffer = "\\\\.\\COM15"; break;
		case 15:  strBuffer = "\\\\.\\COM16"; break;
		case 16:  strBuffer = "\\\\.\\COM17"; break;
		case 17:  strBuffer = "\\\\.\\COM18"; break;
		case 18:  strBuffer = "\\\\.\\COM19"; break;
		case 19:  strBuffer = "\\\\.\\COM20"; break;
		case 20:  strBuffer = "\\\\.\\COM21"; break;
		case 21:  strBuffer = "\\\\.\\COM22"; break;
	}

// IꂽPortOpen

	if((hCommPort = ::CreateFile(strBuffer,
								GENERIC_WRITE | GENERIC_READ,
								0,
								NULL,
								OPEN_EXISTING,
								FILE_ATTRIBUTE_NORMAL,
								NULL)) == INVALID_HANDLE_VALUE)
	{
		iError = ::MessageBox(NULL, "Port Open Error !!!","Warning Message", MB_OK | MB_ICONWARNING);

		if(iError == IDOK)
		{
			return FALSE;
		}
	}

	::SetupComm(hCommPort, 256, 256);

	::GetCommState(hCommPort, &Dcb);
	
	switch(Communication.nBaud)
	{
		default : Dcb.BaudRate = CBR_38400;	break;
		case   0: Dcb.BaudRate = CBR_38400;	break;
		case   1: Dcb.BaudRate = CBR_19200;	break;
		case   2: Dcb.BaudRate = CBR_9600;	break;
		case   3: Dcb.BaudRate = CBR_4800;	break;
		case   4: Dcb.BaudRate = CBR_2400;	break;
		case   5: Dcb.BaudRate = CBR_1200;	break;
	}

	switch(Communication.nData)
	{
		default : Dcb.ByteSize = 8; break;
		case   0: Dcb.ByteSize = 8; break;	
		case   1: Dcb.ByteSize = 7; break;	
	}
	
	switch(Communication.nParity)
	{
		default : Dcb.Parity = NOPARITY;break;
		case 1  : Dcb.Parity = ODDPARITY;break;
		case 2  : Dcb.Parity = EVENPARITY;break;
	}

	switch(Communication.nStop)
	{
		default : Dcb.StopBits = ONESTOPBIT;  break;
		case  1 : Dcb.StopBits = TWOSTOPBITS; break;
	}

	if( iProtocol == 0 )
	{												// Xon/Xoff code Enable
		Dcb.fBinary           = TRUE;				Dcb.fParity         = FALSE;
		Dcb.fOutxCtsFlow      = FALSE;				Dcb.fOutxDsrFlow    = FALSE;
		Dcb.fDtrControl       = DTR_CONTROL_ENABLE; Dcb.fDsrSensitivity = FALSE;
		Dcb.fTXContinueOnXoff = TRUE;
		Dcb.fOutX             = TRUE;				Dcb.fInX			= FALSE;
		Dcb.fErrorChar		  = FALSE;				Dcb.fNull			= FALSE;
		Dcb.fRtsControl		  = RTS_CONTROL_ENABLE;
		Dcb.fAbortOnError	  = FALSE;
		Dcb.XonLim			  = 5;					Dcb.XoffLim			= 5;
		Dcb.XonChar			  = (char) 0x11;		Dcb.XoffChar		= (char) 0x13;
		Dcb.ErrorChar		  = (char) NULL;		Dcb.EofChar			= (char) NULL;
		Dcb.EvtChar			  = (char) NULL;
	}
	else
	{												// Xon/Xoff code Disable
		Dcb.fBinary           = TRUE;				Dcb.fParity         = FALSE;
//				Dcb.fOutxCtsFlow      = FALSE;				Dcb.fOutxDsrFlow    = FALSE;
		Dcb.fOutxCtsFlow      = TRUE;				Dcb.fOutxDsrFlow    = TRUE;
		Dcb.fDtrControl       = DTR_CONTROL_ENABLE; Dcb.fDsrSensitivity = FALSE;
		Dcb.fTXContinueOnXoff = TRUE;
		Dcb.fOutX             = FALSE;				Dcb.fInX			= FALSE;
		Dcb.fErrorChar		  = FALSE;				Dcb.fNull			= FALSE;
		Dcb.fRtsControl		  = RTS_CONTROL_ENABLE;
		Dcb.fAbortOnError	  = FALSE;
		Dcb.XonLim			  = 0;					Dcb.XoffLim			= 0;
		Dcb.XonChar			  = (char) NULL;		Dcb.XoffChar		= (char) NULL;
		Dcb.ErrorChar		  = (char) NULL;		Dcb.EofChar			= (char) NULL;
		Dcb.EvtChar			  = (char) NULL;
	}

	::SetCommState(hCommPort, &Dcb);

	Timeouts.ReadIntervalTimeout         = 0;
	Timeouts.ReadTotalTimeoutMultiplier  = 0;
	Timeouts.ReadTotalTimeoutConstant    = 200;
	Timeouts.WriteTotalTimeoutMultiplier = 10;
	Timeouts.WriteTotalTimeoutConstant   = 200;

	::SetCommTimeouts(hCommPort, &Timeouts);

	::PurgeComm(hCommPort, PURGE_TXABORT | PURGE_TXCLEAR | PURGE_RXABORT | PURGE_RXCLEAR);
//	}*/

	return TRUE;

}
